/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.certs;

import com.ibm.hwmca.fw.certs.CertMgtConstants;
import com.ibm.hwmca.fw.certs.CertUtils;
import com.ibm.hwmca.fw.util.Trace;
import java.io.Serializable;
import java.util.StringTokenizer;
import javax.security.auth.x500.X500Principal;

class CertPrincipal
implements Serializable,
CertMgtConstants {
    private static final String TRACE_MASKD = "XCRTSBJD";
    private static final String TRACE_MASKF = "XCRTSBJF";
    private static final String TRACE_MASKT = "XCRTSBJT";
    private String country = null;
    private String state = null;
    private String locality = null;
    private String org = null;
    private String orgUnit = null;
    private String hostName = null;
    private String eMailAddr = null;

    CertPrincipal(String country, String state, String locality, String org, String orgUnit, String hostName, String eMailAddr) {
        this.country = country;
        this.state = state;
        this.locality = locality;
        this.org = org;
        this.orgUnit = orgUnit;
        this.hostName = hostName;
        this.eMailAddr = eMailAddr;
        Trace.trace(TRACE_MASKT, "<->CertPrincipal(" + country + ", " + state + ", " + locality + ", " + org + ", " + orgUnit + ", " + hostName + ", " + eMailAddr + ")");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    CertPrincipal(X500Principal principal) {
        String principalString = null;
        StringTokenizer st = null;
        StringTokenizer st2 = null;
        String currentToken = null;
        String currentProperty = null;
        String currentValue = null;
        String country = null;
        String state = null;
        String locality = null;
        String org = null;
        String orgUnit = null;
        String hostName = null;
        String eMailAddr = null;
        if (principal == null) throw new IllegalArgumentException("The principal is null.");
        principalString = principal.toString();
        if (principalString == null) throw new IllegalArgumentException("The principal's toString() method is returning null.");
        st = new StringTokenizer(principalString, ",");
        while (st.hasMoreTokens()) {
            currentToken = st.nextToken().trim();
            st2 = new StringTokenizer(currentToken, "=");
            if (st2.countTokens() != 2) continue;
            currentProperty = st2.nextToken();
            currentValue = st2.nextToken();
            if (currentProperty.equals("C")) {
                country = currentValue;
                continue;
            }
            if (currentProperty.equals("ST")) {
                state = currentValue;
                continue;
            }
            if (currentProperty.equals("L")) {
                locality = currentValue;
                continue;
            }
            if (currentProperty.equals("O")) {
                org = currentValue;
                continue;
            }
            if (currentProperty.equals("OU")) {
                orgUnit = currentValue;
                continue;
            }
            if (currentProperty.equals("CN")) {
                hostName = currentValue;
                continue;
            }
            if (currentProperty.equals("EMAILADDRESS")) {
                eMailAddr = currentValue;
                continue;
            }
            Trace.trace(TRACE_MASKD, "Unknown property of " + currentProperty + " and value of " + currentValue);
        }
        this.country = country;
        this.state = state;
        this.locality = locality;
        this.org = org;
        this.orgUnit = orgUnit;
        this.hostName = hostName;
        this.eMailAddr = eMailAddr;
        Trace.trace(TRACE_MASKT, "<->CertPrincipal(" + principal + ")");
    }

    CertPrincipal(CertPrincipal principalToClone) {
        if (principalToClone != null) {
            this.country = principalToClone.country;
            this.state = principalToClone.state;
            this.locality = principalToClone.locality;
            this.org = principalToClone.org;
            this.orgUnit = principalToClone.orgUnit;
            this.hostName = principalToClone.hostName;
            this.eMailAddr = principalToClone.eMailAddr;
        }
    }

    public static void main(String[] args) {
    }

    String getCountry() {
        return this.country;
    }

    String getState() {
        return this.state;
    }

    String getLocality() {
        return this.locality;
    }

    String getOrg() {
        return this.org;
    }

    String getOrgUnit() {
        return this.orgUnit;
    }

    String getHostName() {
        return this.hostName;
    }

    String getEMailAddr() {
        return this.eMailAddr;
    }

    public boolean equals(Object otherObject) {
        boolean result = false;
        CertPrincipal other = null;
        if (otherObject != null && otherObject instanceof CertPrincipal) {
            other = (CertPrincipal)otherObject;
            if ((this.country == null ? other.country == null : this.country.equals(other.country)) && (this.state == null ? other.state == null : this.state.equals(other.state)) && (this.locality == null ? other.locality == null : this.locality.equals(other.locality)) && (this.org == null ? other.org == null : this.org.equals(other.org)) && (this.orgUnit == null ? other.orgUnit == null : this.orgUnit.equals(other.orgUnit)) && (this.hostName == null ? other.hostName == null : this.hostName.equals(other.hostName)) && (this.eMailAddr == null ? other.eMailAddr == null : this.eMailAddr.equals(other.eMailAddr))) {
                result = true;
            }
        }
        return result;
    }

    public String toString() {
        StringBuffer result = null;
        result = new StringBuffer();
        CertUtils.appendPropertyValue("EMAILADDRESS", this.eMailAddr, result);
        CertUtils.appendPropertyValue("CN", this.hostName, result);
        CertUtils.appendPropertyValue("OU", this.orgUnit, result);
        CertUtils.appendPropertyValue("O", this.org, result);
        CertUtils.appendPropertyValue("L", this.locality, result);
        CertUtils.appendPropertyValue("ST", this.state, result);
        CertUtils.appendPropertyValue("C", this.country, result);
        return result.toString();
    }
}

